// hjh 2024-02 gplv3
// messages are in [beats, [message]] format sort of like a score
// preparation messages are not timed
// for my own use, only implementing sendOnTime b/c I don't care the others

TimedBundle : OSCBundle {
	var <>clock;

	*new { |clock(TempoClock.default)|
		^super.new.clock_(clock)
	}

	sendOnTime { |server, delta|
		var callSec;
		if(delta.isNil) {
			this.doPrepare(server, {
				messages.do { |msg|
					clock.sched(msg[0], {
						server.sendBundle(nil, msg[1].value)
					})
				};
			})
		} {
			callSec = SystemClock.seconds;
			this.doPrepare(server, {
				var nowSec = SystemClock.seconds;
				messages.do { |msg|
					clock.sched(msg[0], {
						server.sendBundle(
							delta + callSec - nowSec,
							msg[1].value
						);
					});
				};
			});
		}
	}
}
