// helper functions for "minimum-gate-time adsrs" -- hjh
// problem: note overlaps (in pads)
// cll patterns basically do note releases monophonically
// with this, you can set a parameter to hold a gate open for a minimum time artifically
// the funny filename is to push this file to the front for evaluation

{ |gate = 1, minGateTime = 0, atk = 0.01, dcy = 0.1, sus = 0.6, rel = 0.1, curve = -4, peakLevel = 1, doneAction = 0|
	var rate = UGen.methodSelectorForRate(gate.rate);
	gate = gate + Trig1.perform(rate, gate, minGateTime);
	EnvGen.perform(rate, Env.adsr(atk, dcy, sus, rel, peakLevel, curve), gate, doneAction: doneAction);
} => Func(\adsr);

{ |gate = 1, minGateTime = 0, atk = 0.01, dcy = 0.1, sus = 0.6, rel = 0.1, curve = -4, peakLevel = 1|
	// set doneAction
	var eg = \adsr.eval(gate, minGateTime, atk, dcy, sus, rel, curve, peakLevel, 2);
	// for staccato synths, you might set sus = 0
	// and you don't want the synth to keep running
	FreeSelf.kr(eg <= 0);
	eg
} => Func(\ampAdsr);
