// default synth, default pitch
x = Syn(\default);

// one set call: raise volume,
// and patch a new synth into 'freq'
(
x.set(
	\amp, 0.5,
	\freq, Plug { |base = 400|
		(LFSaw.kr(0.2, mul: 0.7) + LFPulse.kr(12, mul: 0.3))
		.exprange(base * 2, base * 0.5)
	}
);
)

// that new synth exposed another parameter,
// which in turn can be patched to another synth
(
x.set('freq/base', Plug { |low = 300, high = 3000|
	LFDNoise3.kr(0.8).exprange(low, high)
});
)

// and the whole lot cleans up in one go
x.release;