// some modulators, and a reverb

(
SynthDef(\env, { |out, atk = 1.5, rel = 2.0|
	Out.kr(out, EnvGen.kr(Env([0, 1, 0], [atk, rel], [-2, 2]), doneAction: 2));
}).add;

SynthDef(\linmap, { |out, sig, low = 0, high = 1|
	Out.kr(out, sig.linlin(0, 1, low, high));
}).add;

SynthDef(\pitchenv, { |out, dcy = 0.12, freq = 440, ratio = 2|
	Out.kr(out, EnvGen.kr(Env([1, ratio], [dcy], \exp)) * freq);
}).add;

g = Group.new;  // node order: sources before fx

~rvb = {
	var sig = In.ar(0, 2);
	ReplaceOut.ar(
		0,
		FreeVerb2.ar(sig[0], sig[1], 0.35, 0.97, 0.2)
	)
}.play(target: g, addAction: \addAfter);
)

(
r = fork {
	loop {
		var atk = rrand(1.5, 3.5), rel = rrand(2.5, 4.5);
		// pan to follow envelope too, so it's shared
		var env = Plug.shared(\env, [atk: atk, rel: rel]);
		var startPan = #[-1, 1].choose;
		var syn = Syn(\default, [
			amp: Plug(\linmap, [sig: env, low: 0, high: 0.2]),
			freq: Plug(\pitchenv, [dcy: atk + rel,
				freq: exprand(150, 400), ratio: rrand(1.5, 3.7)
			]),
			pan: Plug(\linmap, [sig: env, low: startPan, high: startPan.neg])
		], target: g).play;
		SystemClock.sched(atk + rel, { syn.release });
		(atk * rrand(0.2, 0.6)).wait;
	}
};
)

r.stop;


















(
r = fork {
	loop {
		var atk = rrand(1.5, 3.0), rel = rrand(2.5, 4.0);
		var env = Plug.shared(\env, [atk: atk, rel: rel]);
		var pan1 = #[-1, 1].choose;
		var syn = Syn(\default, [
			amp: Plug(\linmap, [
				sig: env, low: 0, high: 0.2
			]),
			pan: Plug(\linmap, [
				sig: env, low: pan1, high: pan1.neg
			]),
			freq: Plug(\pitchenv, [
				freq: rrand(150.0, 400.0), ratio: rrand(1.8, 3.7),
				dcy: atk + rel
			])
		], g).play;
		SystemClock.sched(atk + rel + 0.2, { syn.release });
		(atk * rrand(0.05, 0.4)).wait;
	}
};
)

r.stop;



(
SynthDef(\pitchenv, { |out, dcy = 0.12, freq = 440, ratio = 2|
	Out.kr(out, EnvGen.kr(Env([ratio, 1], [dcy], \exp)) * freq);
}).add;
)

(
r = fork {
	loop {
		var dur = 0.125 * rrand(1, 5);
		var syn = Syn(\default, [
			freq: Plug(\pitchenv, [freq: exprand(200, 800), ratio: rrand(1.5, 2.5)])
		]).play;
		SystemClock.sched(dur * 0.8 + 0.2, { syn.release });
		dur.wait;
	}
};
)

r.stop;





// mix-and-match sources and filters
(
var noise;

SynthDef(\pulse, { |out, freq = 50, pw = 0.05|
	Out.ar(out, Pulse.ar(freq, pw));
}).add;

noise = Signal.fill(1024, { 1.0.rand2 });

b = Buffer.sendCollection(s, (noise - noise.mean).asWavetable, 1);

SynthDef(\bufnoise, { |out, bufnum, freq = 12, beats = 0.7, modrate = 0.6|
	var sig = COsc.ar(bufnum,
		freq * (1.1 ** LFDNoise3.kr(modrate)),
		beats * (2 ** LFDNoise3.kr(modrate))
	);
	Out.ar(out, sig);
}).add;

SynthDef(\fbnoise, { |out, freq = 23, fb = 0.77|
	var sig = SinOscFB.ar(freq, fb);
	Out.ar(out, sig);
}).add;

~sourceParms = (
	pulse: Pbind(\freq, Pexprand(50, 90, inf), \pw, Pwhite(0.02, 0.15, inf)).asStream,
	bufnoise: Pbind(
		\freq, Pexprand(8, 22, inf),
		\beats, Pwhite(0.5, 1.2, inf),
		\bufnum, b
	).asStream,
	fbnoise: Pbind(\freq, Pexprand(17, 88, inf), \fb, Pwhite(1.5, 7.0, inf)).asStream
);

// filters
SynthDef(\reson3, { |out, freq = 440, ratios = #[1, 2.5, 3.5], atk = 0.3, dcy = 3, amp = 0.1|
	var in = NamedControl.ar(\in, 0) * Decay2.kr(Impulse.kr(0), 0.01, 0.7);
	var sig = Formlet.ar(in, freq * ratios, atk, dcy);
	DetectSilence.ar(sig, doneAction: 2);
	Out.ar(out, (Limiter.ar(sig, 0.99) * amp * 0.3).dup);
}).add;

SynthDef(\bpf, { |out, gate = 1, freq = 440, atk = 0.3, dcy = 3, amp = 0.1|
	var eg = EnvGen.kr(Env.asr(atk, 1, dcy), gate, doneAction: 2);
	var in = NamedControl.ar(\in, 0);
	var rq = Lag.kr(ToggleFF.kr(Dust.kr(12)), 0.08) * 0.7 + 0.05;
	var sig = BPF.ar(in, freq, rq) / rq;
	Out.ar(out, (sig * eg * amp).dup);
}).add;

SynthDef(\fft, { |out, gate = 1, wipe = 0.7, atk = 0.3, dcy = 3, amp = 0.1|
	var eg = EnvGen.kr(Env.asr(atk, 1, dcy), gate, doneAction: 2);
	var in = NamedControl.ar(\in, 0);
	var fft = FFT(LocalBuf(256, 1), in);
	fft = PV_RandComb(fft, wipe);
	Out.ar(out, (IFFT(fft) * eg * amp).dup);
}).add;

~filterParms = (
	reson3: Pbind(\freq, Pexprand(100, 700, inf)).asStream,
	bpf: Pbind(\freq, Pexprand(100, 700, inf)).asStream,
	fft: Pbind(\freq, Pexprand(100, 700, inf), \wipe, Pwhite(0.8, 0.93, inf)).asStream
);
)

(
r = fork {
	loop {
		var src = #[pulse, bufnoise, fbnoise].choose;
		var filt = #[reson3, bpf, fft].choose;
		var delta = exprand(0.1, 0.8);
		var dcy = delta * exprand(0.3, 5);
		var syn = Syn(
			filt,
			[
				in: Plug(src, ~sourceParms[src].next(()).asPairs),
				dcy: dcy
			] ++ ~filterParms[filt].next(()).asPairs
		).play;
		thisThread.clock.sched(rrand(0.4, 0.8), { syn.release });
		delta.wait;
	}
};
)

r.stop;
